// Cocos2d v3 came from the documentation of the file format specification at
// http://zwoptexapp.com/documentation/

function getPluginInfo(lang)
{
//	fl.trace("==== getPluginInfo");
//	fl.trace(lang);
//	fl.trace("---- getPluginInfo");

	pluginInfo = new Object();
	pluginInfo.id = "cocos2Dv3";
	pluginInfo.name = "cocos2D v3";
	pluginInfo.ext = "plist";
	pluginInfo.encoding = "UTF8";
	pluginInfo.capabilities = new Object();
	pluginInfo.capabilities.canRotate = true;
	pluginInfo.capabilities.canTrim = true;
	pluginInfo.capabilities.premultipliedAlpha = true;
	pluginInfo.capabilities.canShapePad = true;
	pluginInfo.capabilities.canBorderPad = true;
	pluginInfo.capabilities.canStackDuplicateFrames = true;
	
	return pluginInfo;
}

function beginExport(meta)
{
//	fl.trace("==== endExport");
//	fl.trace(meta.app);
//	fl.trace(meta.version);
//	fl.trace(meta.image);
//	fl.trace(meta.format);
//	fl.trace(meta.size.w);
//	fl.trace(meta.size.h);
//	fl.trace(meta.scale);
//	fl.trace("---- endExport");

	var s = '<?xml version="1.0" encoding="UTF-8"?>\n';
	s += '<!DOCTYPE plist PUBLIC "-//Apple Computer//DTD PLIST 1.0//EN" "http://www.apple.com/DTDs/PropertyList-1.0.dtd">\n';
	s += '<plist version="1.0">\n';
	s += '\t<dict>\n';
	s += '\t\t<key>frames</key>\n';
	s += '\t\t<dict>\n';

	return s;
}

function frameExport(frame)
{
//	fl.trace("==== frameExport");
//	fl.trace(frame.id);
//	fl.trace(frame.frame.x);
//	fl.trace(frame.frame.y);
//	fl.trace(frame.frame.w);
//	fl.trace(frame.frame.h);
//	fl.trace(frame.offsetInSource.x);
//	fl.trace(frame.offsetInSource.y);
//	fl.trace(frame.sourceSize.w);
//	fl.trace(frame.sourceSize.h);
//	fl.trace(frame.rotated);
//	fl.trace(frame.trimmed);
//	fl.trace(frame.frameNumber);
//	fl.trace(frame.symbolName);
//	fl.trace(frame.frameLabel);
//	fl.trace(frame.lastFrameLabel);
//	fl.trace("---- frameExport");

	var s ='\t\t\t<key>' + frame.id + '</key>\n';
	
	s += '\t\t\t<dict>\n';

	s += '\t\t\t\t<key>aliases</key>\n';
	s += '\t\t\t\t<array/>\n';

	s += '\t\t\t\t<key>sourceColorRect</key>\n';
	var scrx = frame.sourceSize.w - frame.frame.w;
	var scry = frame.sourceSize.h - frame.frame.h;
	s += '\t\t\t\t<string>{{' + scrx + ',' + scry + '},{' + frame.frame.w + ',' + frame.frame.h + '}}</string>\n';

	s += '\t\t\t\t<key>spriteOffset</key>\n';
	var srcofsx = 0 - frame.offsetInSource.x;
	var srcofsy = 0 - frame.offsetInSource.y;
	s += '\t\t\t\t<string>{' + srcofsx + ',' + srcofsy + '}</string>\n';

	s += '\t\t\t\t<key>spriteSize</key>\n';
	s += '\t\t\t\t<string>{' + frame.sourceSize.w + ',' + frame.sourceSize.h + '}</string>\n';

	s += '\t\t\t\t<key>spriteSourceSize</key>\n';
	s += '\t\t\t\t<string>{' + frame.frame.w + ',' + frame.frame.h + '}</string>\n';

	s += '\t\t\t\t<key>spriteTrimmed</key>\n';
	s += '\t\t\t\t<' + frame.trimmed + '/>\n';

	s += '\t\t\t\t<key>textureRect</key>\n';
	s += '\t\t\t\t<string>{{' + frame.frame.x + ',' + frame.frame.y + '},{' + frame.frame.w + ',' + frame.frame.h + '}}</string>\n';

	s += '\t\t\t\t<key>textureRotated</key>\n';
	s += '\t\t\t\t<' + frame.rotated + '/>\n';

	s += '\t\t\t</dict>\n';

	return s;
}

function endExport(meta)
{
//	fl.trace("==== endExport");
//	fl.trace(meta.app);
//	fl.trace(meta.version);
//	fl.trace(meta.image);
//	fl.trace(meta.format);
//	fl.trace(meta.size.w);
//	fl.trace(meta.size.h);
//	fl.trace(meta.scale);
//	fl.trace("---- endExport");
	
	var s = '\t\t</dict>\n';
	s += '\t\t<key>metadata</key>\n';

	s += '\t\t<dict>\n';

	s += '\t\t\t<key>format</key>\n';
	s += '\t\t\t<integer>3</integer>\n';

	s += '\t\t\t<key>size</key>\n';
	s += '\t\t\t<string>{' + meta.sheetWidth + ',' + meta.sheetHeight + '}</string>\n';

	// Target information seems to be optional
	s += '\t\t\t<key>target</key>\n'
	s += '\t\t\t<dict>\n'

	s += '\t\t\t\t<key>name</key>\n';
	s += '\t\t\t\t<string>' + meta.image + '</string>\n';

	var fname = meta.image;
	var fext = "";
	var ndx = meta.image.lastIndexOf('.');
	if (ndx > 0)
	{
		fname = meta.image.substr(0, ndx);
		if (ndx < meta.image.length)
			fext = meta.image.slice(ndx + 1);
	}
		
	s += '\t\t\t\t<key>textureFileName</key>\n';
	s += '\t\t\t\t<string>' + fname + '</string>\n';

	s += '\t\t\t\t<key>textureFileExtension</key>\n';
	s += '\t\t\t\t<string>' + fext + '</string>\n';

	s += '\t\t\t\t<key>premultipliedAlpha</key>\n';
	s += '\t\t\t\t<true/>\n';

	s += '\t\t\t</dict>\n'

	s += '\t\t</dict>\n';

	s += '\t</dict>\n';
	s += '</plist>\n';

	return s;
}
